/*
 * Stats.cpp
 *
 *  Created on: 12.11.2012
 *      Author: Maik Stubbe
 *
 * Copyright (2012) Maik Stubbe
 *
 * This file is part of nDarX.
 *
 * nDarX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version.
 * 
 * nDarx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with nDarx.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Stats.h"

void stats()
{
	WINDOW *m_window;
	WINDOW *st_window;
	bool stop=false;
	bool exist=false;
	int ch;
	int startx, starty;
	int highlight=1;
	ifstream fh;
	char buf[100];
	int y=1;
	int i=0;
	int j,k;
	int array_max=250;
	string output;
	string pname;
	string apname[array_max];

	startx=get_mstartx();
	starty=get_mstarty();


	m_window = create_newwin(get_mheight(),get_mwidth(),starty,startx);
	st_window = create_newwin(get_mheight()-2,get_mwidth()-2,starty+1,startx+1);
	keypad(st_window,TRUE);

	wrefresh(st_window);

	fh.open(get_sfile().c_str());



	while(fh.getline(buf,sizeof(buf)))
	{
		output = string(buf);
		pname = output.substr(output.find(";")+1,output.substr(output.find(";")).size()-output.substr(output.find(";",output.find(";")+1)).size()-1);

		if (i == 0)
		{
			apname[i] = pname;
			i++;
		}
		else
		{
			for (k=0;k<=i-1;k++)
			{
				if (apname[k].compare(pname) == 0)
				{
					exist = true;
					break;
				}

			}

			if (!exist)
			{
				apname[i] = pname;
				i++;
			}
		}

		y++;
	}


	fh.close();

	print_statsmenu(st_window,highlight,apname,i);

	while (!stop)
	{
		ch = wgetch(st_window);
		switch(ch)
		{	case KEY_UP:
				if(highlight == 1)
					highlight = i;
				else
					--highlight;
				break;
			case KEY_DOWN:
				if(highlight == i)
					highlight = 1;
				else
					++highlight;
				break;
			case 10:
				open_stats(apname[highlight-1], st_window);
				break;
			case 113:
				stop=true;
				break;
			default:
				break;
		}
		print_statsmenu(st_window,highlight,apname,i);
	}

	destroy_win(m_window);
	destroy_win(st_window);
}


void save_stats(const char *pname, int game, int throws, int t60, int t100, int t140, int t180)
{
	ofstream fh;
	float ave;

	time_t now = time(0);
	tm *dt = localtime(&now);

	ave = (float)game/throws;

	fh.open(get_sfile().c_str(),fstream::app);

	fh << setw(2) << setfill('0') << dt->tm_mday<<"." << dt->tm_mon+1 << "." << 1900+dt->tm_year << " " << dt->tm_hour<< ":" <<dt->tm_min << ";";
	fh << pname << ";" << game << ";" << throws << ";" << ave*3 << ";" << t60 << ";" << t100 << ";" << t140 << ";" << t180 << "\n";

	fh.close();

}

string get_sfile()
{
	int uid;
	passwd *myPasswd;
	string settingsDir;
	string statsFile;
	uid = getuid();
	struct stat st;
	ofstream fh;

	myPasswd = getpwuid(uid);

	settingsDir = myPasswd->pw_dir;
	settingsDir+="/.nDarx/";
	statsFile=settingsDir+"stats";

	if (!((stat(settingsDir.c_str(),&st) == 0) && ((st.st_mode) & S_IFMT) == S_IFDIR))
		mkdir(settingsDir.c_str(),0700);

	return statsFile;

}

void print_statsmenu(WINDOW *menu_win, int highlight, string schoices[], int count)
{
	int x, y, i;

	x = 2;
	y = 2;

	box(menu_win, 0, 0);
	for(i = 0; i < count; ++i)
	{	if(highlight == i + 1)
		{	wattron(menu_win, A_REVERSE);
			mvwprintw(menu_win, y, x, "%s", schoices[i].c_str());
			wattroff(menu_win, A_REVERSE);
		}
		else
			mvwprintw(menu_win, y, x, "%s", schoices[i].c_str());
		++y;
	}
	wrefresh(menu_win);
}

void print_stats(WINDOW *pwindow, string param[][2], int count, int highlight, char *whitespace)
{
	int x, y, i, l, start;

	x = 1;
	y = 3;

	wclear(pwindow);
	box(pwindow,0,0);

	wattron(pwindow,A_BOLD);
	mvwprintw(pwindow,1,1,"Game - Date - Average - Throws");
	wattron(pwindow,A_UNDERLINE);
	mvwprintw(pwindow,2,1,"60s - 100s - 140s - 180s%s",whitespace);
	wattroff(pwindow,A_UNDERLINE);
	wattroff(pwindow,A_BOLD);

	if (highlight+9 <= count)
	{
		count = highlight+8;
	}
	else
	{
		count = count+1;
	}


	for(i = highlight-1; i <count; i++)
	{
		if(highlight == i+1 )
		{	wattron(pwindow, A_REVERSE);
			mvwprintw(pwindow,y,x,"%s",param[i][0].c_str());
			wattron(pwindow,A_UNDERLINE);
			mvwprintw(pwindow,y+1,x,"%s",param[i][1].c_str());
			wattroff(pwindow,A_UNDERLINE);
			wattroff(pwindow, A_REVERSE);
		}
		else
		{
			mvwprintw(pwindow,y,x,"%s",param[i][0].c_str());
			wattron(pwindow,A_UNDERLINE);
			mvwprintw(pwindow,y+1,x,"%s",param[i][1].c_str());
			wattroff(pwindow,A_UNDERLINE);
		}
		y+=2;
	}

	wrefresh(pwindow);
}

void open_stats(string pname, WINDOW *pwindow)
{
	ifstream fh;
	char buf[100];
	string output, _pname, param[10000][2];
	string date, game, t60, t100, t140, t180, throws;
	int i=1;
	int ch;
	int j=0;
	int k=0;
	int l;
	int highlight=1;
	const char *line[10000][9];
	const char* p;
	int x,y;
	bool stop=false;

	wclear(pwindow);
	box(pwindow,0,0);
	wrefresh(pwindow);

	getmaxyx(pwindow,y,x);

	char whitespace[200];

	for (l=0;l<x-strlen("60s - 100s - 140s - 180s")-2;l++)
	{
		strcat(whitespace," ");
	}

	wattron(pwindow,A_BOLD);
	mvwprintw(pwindow,1,1,"Game - Date - Average - Throws");
	wattron(pwindow,A_UNDERLINE);
	mvwprintw(pwindow,2,1,"60s - 100s - 140s - 180s%s",whitespace);
	wattroff(pwindow,A_UNDERLINE);
	wattroff(pwindow,A_BOLD);
	wrefresh(pwindow);


	strcpy(whitespace,"");

	fh.open(get_sfile().c_str());

	while(fh.getline(buf,sizeof(buf)))
	{
		output = string(buf);
		_pname = output.substr(output.find(";")+1,output.substr(output.find(";")).size()-output.substr(output.find(";",output.find(";")+1)).size()-1);


		if (pname.compare(_pname)==0)
		{
			for (p=strtok(buf, ";"); p; p= strtok(NULL,";"))
			{
				line[j][k]=p;
				k++;
			}

			for (l=0;l<x-strlen(line[j][5])+strlen(line[j][6])+strlen(line[j][7])+strlen(line[j][8])-17;l++)
			{
				strcat(whitespace," ");
			}

			param[j][0] = string(line[j][2])+ " - "+ string(line[j][0]) + " - " + string(line[j][4]) + " - " + string(line[j][3]);
			param[j][1] = string(line[j][5])+" - "+string(line[j][6]) + " - " + string(line[j][7]) + " - " + string(line[j][8]) + string(whitespace);
			strcpy(whitespace,"");

			j++;
			k=0;
		}
	}

	fh.close();

	//s_pad = newpad(y,x);
	print_stats(pwindow, param, j,  highlight,whitespace);


	while(!stop)
	{
		ch = wgetch(pwindow);
		switch(ch)
		{	case KEY_UP:
				if(highlight == 1)
					highlight = j;
				else
					highlight--;
				break;
			case KEY_DOWN:
				if(highlight == j)
					highlight = 1;
				else
					highlight++;
				break;
			case 113:
				stop=true;
				break;
			default:
				break;
		}
		print_stats(pwindow, param, j,  highlight,whitespace);
	}

	wclear(pwindow);
	box(pwindow,0,0);
	wrefresh(pwindow);

}
