/*
 * Settings.h
 *
 *  Created on: 09.11.2012
 *      Author: Maik Stubbe
 *
 * Copyright (2012) Maik Stubbe
 *
 * This file is part of nDarX.
 *
 * nDarX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version.
 * 
 * nDarx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with nDarx.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SETTINGS_H_
#define SETTINGS_H_

#include <fstream>
#include <iostream>
#include <pwd.h>
#include <unistd.h>
#include "Windows.h"
#include <sys/stat.h>
#include <dirent.h>
#include <string.h>
#include <stdlib.h>

using std::ofstream;
using std::string;
using namespace std;

void settings();
void save_settings(ofstream fh);
string read_settings(ifstream fh);
string get_cfile();
int get_game();
int get_int(const char* conf, int confdefault);
string get_pname();
string get_string(const char* conf, const char* confdefault);
void write_settings(const char* setting, const char* defsetting);
void write_settings(const char* setting, int defsetting);

#endif /* SETTINGS_H_ */
