/*
 * Player.h
 *
 *  Created on: 08.11.2012
 *      Author: Maik Stubbe
 *
 * Copyright (2012) Maik Stubbe
 *
 * This file is part of nDarX.
 *
 * nDarX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version.
 * 
 * nDarx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with nDarx.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PLAYER_H_
#define PLAYER_H_


class Player {
public:
	Player(int score, int player, const char *pname, int allTime);

	virtual ~Player();

	void set_score(int score);

	int get_score();
	void reset(int startScore);
	float get_ave(int startScore);
	float get_ave();
	int get_t60();
	int get_gt60();
	void set_t60();
	int get_t100();
	int get_gt100();
	void set_t100();
	int get_t140();
	int get_gt140();
	void set_t140();
	int get_t180();
	int get_gt180();
	void set_t180();
	int get_throws();
	int get_gthrows();
	void set_throws(int lastThrow);

private:
	int _score;
	int _player;
	const char *_pname;
	int _throws;
	int _gthrows;
	int _t60;
	int	_gt60;
	int _t100;
	int	_gt100;
	int _t140;
	int	_gt140;
	int _t180;
	int	_gt180;
	int _games;
	int _allTime;
};

#endif /* PLAYER_H_ */
