/*
 * Player.cpp
 *
 *  Created on: 08.11.2012
 *      Author: Maik Stubbe
 *
 * Copyright (2012) Maik Stubbe
 *
 * This file is part of nDarX.
 *
 * nDarX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version.
 * 
 * nDarx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with nDarx.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Player.h"

Player::Player(int score, int player, const char *pname, int allTime):
	_score(score),
	_player(player),
	_pname(pname),
	_throws(0),
	_gthrows(0),
	_t60(0),
	_gt60(),
	_t100(0),
	_gt100(0),
	_t140(0),
	_gt140(0),
	_t180(0),
	_gt180(0),
	_allTime(allTime),
	_games(1)
{}



Player::~Player() {
}

void Player::set_score(int score)
{
	_score=score;
	if (_score != 0)
	{
		_gthrows+=3;
		_throws+=3;
	}

}

int Player::get_score()
{
	return _score;
}

int Player::get_throws()
{
	return _throws;
}
int Player::get_gthrows()
{
	return _gthrows;
}

void Player::reset(int startScore)
{
	_score=startScore;
	if (_allTime == 1)
	{
		_games++;
	}
	else
	{
		_throws=0;
		_t60=0;
		_t100=0;
		_t140=0;
		_t180=0;
	}
	_gthrows=0;
	_gt60=0;
	_gt100=0;
	_gt140=0;
	_gt180=0;
}

float Player::get_ave(int startScore)
{
	float ret;

	if (_throws == 0)
		ret = (float)0;
	else
	{
		if (_allTime == 1)
			startScore= _games*startScore;

		ret = ((float)(startScore-_score)/_throws);
	}
	return ret;
}

float Player::get_ave()
{
	float ret;

	if (_throws == 0)
		ret = (float)0;
	else
	{
		ret = (float)(_score/_throws);
	}

	return ret;
}


int Player::get_t60()
{
	return _t60;
}
int Player::get_gt60()
{
	return _gt60;
}
void Player::set_t60()
{
	_gt60++;
	_t60++;
}
int Player::get_t100()
{
	return _t100;
}
int Player::get_gt100()
{
	return _gt100;
}
void Player::set_t100()
{
	_gt100++;
	_t100++;
}
int Player::get_t140()
{
	return _t140;
}
int Player::get_gt140()
{
	return _gt140;
}
void Player::set_t140()
{
	_gt140++;
	_t140++;
}
int Player::get_t180()
{
	return _t180;
}
int Player::get_gt180()
{
	return _gt180;
}
void Player::set_t180()
{
	_gt180++;
	_t180++;
}

void Player::set_throws(int lastThrow)
{
	_gthrows += lastThrow;
	_throws += lastThrow;
}
