/*
 * Highscore.c
 *
 *  Created on: 08.11.2012
 *      Author: Maik Stubbe
 *
 * Copyright (2012) Maik Stubbe
 *
 * This file is part of nDarX.
 *
 * nDarX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version.
 * 
 * nDarx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with nDarx.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Highscore.h"


void highscore(const char *pname)
{
	WINDOW *h_window;
	WINDOW *i_window;
	WINDOW *s_window;
	WINDOW *m_window;
	Player p1(0,1,"Player",1);
	int ch, startx, starty;
	int height = 4;
	int width = 10;
	int mheight=get_mheight();
	int mwidth=get_mwidth();
	int swidth=get_mwidth()-16;
	int sheight=8;
	int score;
	char str[3];
	float ave;

	startx = get_mstartx()+8;
	starty = get_mstarty()+3;

#ifdef debug
//	printw("pname: %s",pname);
//	refresh();
#endif

	m_window = create_newwin(mheight,mwidth,get_mstarty(),get_mstartx());
	h_window = create_newwin(height,width,starty,startx);
	i_window = create_newwin(height,width,starty,startx+width+18);
	s_window = create_newwin(sheight,swidth,starty+height+1,startx);
	echo();
	keypad(i_window,TRUE);
	mvwprintw(i_window,1,1,"Scored:");
	mvwprintw(h_window,1,1,"Score:");
	mvwprintw(h_window,2,1,"%d",p1.get_score());
	wrefresh(h_window);


	wattron(s_window,A_BOLD);
	mvwprintw(s_window,1,swidth/2-sizeof("1-Dart Ave")/2,"1-Dart Ave");
	mvwprintw(s_window,3,swidth/2-sizeof("3-Dart Ave")/2,"3-Dart Ave");
	mvwprintw(s_window,5,swidth/2-sizeof("60 - 100 - 140 - 180")/2,"60 - 100 - 140 - 180");
	wattroff(s_window,A_BOLD);

	wattron(m_window,A_BOLD);
	mvwprintw(m_window,1,(get_mwidth()/2)-3,"Player");
	wattroff(m_window,A_BOLD);
	mvwprintw(m_window,2,(get_mwidth()/2)-(sizeof(pname)/2),pname);


	wmove(i_window,2,1);

	wrefresh(h_window);
	wrefresh(i_window);
	wrefresh(s_window);
	wrefresh(m_window);




	bool stop = false;

	while (!stop)
	{

		wgetstr(i_window,str);
		if (strcmp(str,"q") == 0)
		{
			stop = true;
		}
		else
		{
			score = atoi(str);
			p1.set_score(score+p1.get_score());
			mvwprintw(i_window,2,1,"    ");
			wmove(i_window,2,1);
			wrefresh(i_window);

			if (score == 180)
				p1.set_t180();
			else if (score >= 140)
				p1.set_t140();
			else if (score >= 100)
				p1.set_t100();
			else if (score >=60)
				p1.set_t60();

		}

		ave = p1.get_ave();
		mvwprintw(s_window,2,swidth/2-sizeof(ave)/2,"%f",ave);
		mvwprintw(s_window,4,swidth/2-sizeof(ave)/2,"%f",ave*3);
		mvwprintw(s_window,6,swidth/2-6,"%d - %d - %d - %d",p1.get_t60(),p1.get_t100(),p1.get_t140(),p1.get_t180());
		wrefresh(s_window);
		mvwprintw(h_window,1,1,"Score:");
		mvwprintw(h_window,2,1,"%d",p1.get_score());
		wrefresh(h_window);
	}
	wprintw(h_window,"       \n       ");
	wprintw(i_window,"       \n       ");
	destroy_win(h_window);
	destroy_win(i_window);

}

