/*
 * main.c
 *
 *  Created on: 07.11.2012
 *      Author: Maik Stubbe
 *
 * Copyright (2012) Maik Stubbe
 *
 * This file is part of nDarX.
 *
 * nDarX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version.
 * 
 * nDarx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with nDarx.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string.h>
#include "Windows.h"
#include "Highscore.h"
#include "Game.h"
#include "Settings.h"


WINDOW *main_win;

int main(int argc, char *argv[])
{	WINDOW *control_win;
	int startx, starty, width, height, mstartx, mstarty, mwidth, mheight;
	int ch;
	int highlight=1;
	int choice=0;
	int n_choices = get_choices();
	bool stop=false;

	initscr();
	cbreak();
	curs_set(0);
	noecho();

	height = get_height();
	mheight = get_mheight();
	width = get_width();
	mwidth = get_mwidth();
	starty = get_starty();
	mstarty = get_mstarty();
	startx = get_startx();
	mstartx = get_mstartx();

	mvprintw(starty-1,startx,"Press q to exit\n");

#ifdef debug
	//printw("Alltime: %d - Ende",get_int("ALLTIME"));
	//printw("height: %d - mheight: %d - width: %d  - mwidth: %d - starty: %d - mstarty: %d - startx: %d - mstartx: %d\n",height,mheight,width,mwidth,starty,mstarty,startx,mstartx);
#endif
	refresh();

	control_win = create_newwin(height, width, starty, startx);
	main_win = create_newwin(mheight,mwidth,mstarty, mstartx);
	keypad(control_win, TRUE);

	print_menu(control_win,highlight);

	while(!stop)
	{
		ch = wgetch(control_win);
		switch(ch)
		{	case KEY_UP:
				if(highlight == 1)
					highlight = n_choices;
				else
					--highlight;
				break;
			case KEY_DOWN:
				if(highlight == n_choices)
					highlight = 1;
				else
					++highlight;
				break;
			case 10:
				switch (highlight)
				{
				case 1:
					echo();
					game(get_pname().c_str(),get_game(), get_int("ALLTIME",0));
					main_win = create_newwin(mheight,mwidth,mstarty, mstartx);
					noecho();
					break;
				case 2:
					break;
				case 3:
					break;
				case 4:
					break;
				case 5:
					break;
				case 6:
					highscore(get_pname().c_str());
					main_win = create_newwin(mheight,mwidth,mstarty, mstartx);
					break;
				case 7:
					stats();
					main_win = create_newwin(mheight,mwidth,mstarty, mstartx);
					break;
				case 8:
					settings();
					main_win = create_newwin(mheight,mwidth,mstarty, mstartx);
					break;
				default:
					break;
				}
				choice = highlight;
				break;
			case 113:
				stop = true;
				break;
			default:
				break;
		}
		print_menu(control_win,highlight);
	}

	endwin();			/* End curses mode		  */
	return 0;
}

WINDOW get_win()
{
	return *main_win;
}
