/*
 * X01.cpp
 *
 *  Created on: 08.11.2012
 *      Author: Maik Stubbe
 *
 * Copyright (2012) Maik Stubbe
 *
 * This file is part of nDarX.
 *
 * nDarX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version.
 * 
 * nDarx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with nDarx.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "X01.h"

X01::X01(Player *player):
	_player(player){}

X01::~X01() {
}

int X01::get_score()
{
	return _player->get_score();
}

int X01::set_score(int score)
{
	if (score < 181 && score > -1)
	{
		if (!check_throw_over(score))
		{
			_player->set_score(_player->get_score()- score);

			if (score == 180)
			{
				_player->set_t180();
			}
			else if (score >= 140)
			{
				_player->set_t140();
			}
			else if (score >= 100)
			{
				_player->set_t100();
			}
			else if (score >= 60)
			{
				_player->set_t60();
			}

			return _player->get_score();
		}
		else
		{
			_player->set_score(_player->get_score());
			return -1;
		}

	}
	else
		return -1;
}

bool X01::check_throw_over(int score)
{
	if (_player->get_score()-score < 0)
		return true;
	else
		return false;
}

void X01::restart(int startScore)
{
	_player->reset(startScore);
}

float X01::get_ave(int startScore)
{
	return _player->get_ave(startScore);
}

int X01::get_t60()
{
	return _player->get_t60();
}
int X01::get_t100()
{
	return _player->get_t100();
}
int X01::get_t140()
{
	return _player->get_t140();
}
int X01::get_t180()
{
	return _player->get_t180();
}
int X01::get_gt60()
{
	return _player->get_gt60();
}
int X01::get_gt100()
{
	return _player->get_gt100();
}
int X01::get_gt140()
{
	return _player->get_gt140();
}
int X01::get_gt180()
{
	return _player->get_gt180();
}
void X01::set_throws(int lastThrow)
{
	_player->set_throws(lastThrow);
}
int X01::get_throws()
{
	return _player->get_throws();
}
int X01::get_gthrows()
{
	return _player->get_gthrows();
}


