/*
 * Windows.c
 *
 *  Created on: 07.11.2012
 *      Author: Maik Stubbe
 *
 * Copyright (2012) Maik Stubbe
 *
 * This file is part of nDarX.
 *
 * nDarX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version.
 * 
 * nDarx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with nDarx.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <ncurses.h>
#include <string.h>
#include "Windows.h"

#define myLINES 24
#define myCOLS 80

char *choices[] = {
			"501 - 1 Player",
			"501 - 1 Player vs. me",
			"501 - 2 Player",
			"Cricket - 1 Player",
			"Cricket - 2 Player",
			"Highscore",
			"Stats",
			"Settings"
		  };
int n_choices = sizeof(choices) / sizeof(char *);

int get_choices()
{
	return n_choices;
}
int get_height()
{
	return myLINES;
}
int get_mheight()
{
	return get_height();
}
int get_width()
{
	return myCOLS/3;
}
int get_mwidth()
{
	return myCOLS-get_width();
}
int get_starty()
{
	return LINES/2-get_height()/2;
}
int get_mstarty()
{
	return get_starty();
}
int get_startx()
{
	return COLS/2-myCOLS/2;
}
int get_mstartx()

{
	return get_startx()+get_width();
}

int get_hstartx()
{
	int ret;

	ret = get_mstartx() + get_mwidth()/2;

	return ret;
}
int get_hstarty()
{
	int ret;

	ret = get_starty()+get_mheight()/2;

	return ret;
}

WINDOW *create_newwin(int height, int width, int starty, int startx)
{	WINDOW *local_win;

	local_win = newwin(height, width, starty, startx);
	box(local_win, 0 , 0);
	wrefresh(local_win);

	return local_win;
}


void destroy_win(WINDOW *local_win)
{

	wborder(local_win, ' ', ' ', ' ',' ',' ',' ',' ',' ');

	werase(local_win);
	wrefresh(local_win);
	delwin(local_win);
}

void cprint(WINDOW *localwin, char *msg)
{
	mvwprintw(localwin,1,1,"%s",msg);
	wrefresh(localwin);
}


void print_menu(WINDOW *menu_win, int highlight)
{
	int x, y, i;

	x = 2;
	y = 2;
	box(menu_win, 0, 0);
	for(i = 0; i < n_choices; ++i)
	{	if(highlight == i + 1) /* High light the present choice */
		{	wattron(menu_win, A_REVERSE);
			mvwprintw(menu_win, y, x, "%s", choices[i]);
			wattroff(menu_win, A_REVERSE);
		}
		else
			mvwprintw(menu_win, y, x, "%s", choices[i]);
		++y;
	}
	wmove(menu_win,0,0);
	wrefresh(menu_win);
}
