/*
 * Settings.cpp
 *
 *  Created on: 09.11.2012
 *      Author: Maik Stubbe
 *
 * Copyright (2012) Maik Stubbe
 *
 * This file is part of nDarX.
 *
 * nDarX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version.
 * 
 * nDarx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with nDarx.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Settings.h"

using namespace std;


void settings()
{
	WINDOW *m_window;
	WINDOW *s_window;
	bool stop=false;
	int game, ch, alltime;
	const char *pname;
	int startx, starty;

	startx=get_mstartx();
	starty=get_mstarty();


	m_window = create_newwin(get_mheight(),get_mwidth(),starty,startx);
	s_window = create_newwin(get_mheight()-2,get_mwidth()-2,starty+1,startx+1);
	keypad(s_window,TRUE);
	game = get_game();

	alltime = get_int("ALLTIME",0);
	pname = get_string("PNAME","Player 1").c_str();


	mvwprintw(s_window,2,2,"Playername:");
	mvwprintw(s_window,4,2,"x01-Score:");
	mvwprintw(s_window,6,2,"Averages per Game / Session:");
	wrefresh(s_window);


	while (!stop)
	{

		mvwprintw(s_window,3,2,"%s",pname);
		mvwprintw(s_window,5,2,"%d",game);
		if (alltime == 0)
			mvwprintw(s_window,7,2,"Game");
		else if ( alltime == 1)
			mvwprintw(s_window,7,2,"Session");

		wrefresh(s_window);

		ch = wgetch(s_window);
		stop=true;
	}

	destroy_win(m_window);
	destroy_win(s_window);

}

void save(ofstream fh)
{

}

string read(ifstream fh)
{
	char ret[256];
	fh.getline(ret,sizeof(ret));
	return ret;

}

string get_cfile()
{
	int uid;
	passwd *myPasswd;
	string settingsDir;
	string settingsFile;
	uid = getuid();
	struct stat st;
	ofstream fh;

	myPasswd = getpwuid(uid);

	settingsDir = myPasswd->pw_dir;
	settingsDir+="/.nDarx/";
	settingsFile=settingsDir+"conf";

	if (!((stat(settingsDir.c_str(),&st) == 0) && ((st.st_mode) & S_IFMT) == S_IFDIR))
		mkdir(settingsDir.c_str(),0700);

	if (!((stat(settingsFile.c_str(),&st) == 0) && ((st.st_mode) & S_IFMT) == S_IFREG))
	{
		fh.open(settingsFile.c_str(),ofstream::app);

		fh << "PNAME=Player 1\n";
		fh << "GAME=501\n";
		fh << "ALLTIME=0";
		fh.close();
	}

	return settingsFile;

}

int get_game()
{
	ifstream fh;
	char buf[25];
	int ret;
	string str;

	fh.open(get_cfile().c_str());
	while(fh.getline(buf,sizeof(buf)))
	{
		if (strncmp(buf,"GAME=",5)==0)
		{
			std::string str(buf);
			ret=atoi(str.substr(5,str.size()-5).c_str());
		}
	}

	fh.close();

	return ret;

}
string get_pname()
{
	ifstream fh;
	char buf[25];
	string ret;
	string str;

	fh.open(get_cfile().c_str());
	while(fh.getline(buf,sizeof(buf)))
	{
		if (strncmp(buf,"PNAME=",6)==0)
		{
			std::string str(buf);
			ret=str.substr(6,str.size()-6);
		}
	}

	fh.close();

	return ret;

}

void write_settings(const char* setting, const char* defsetting)
{
	ofstream fh;
	fh.open(get_cfile().c_str(),ofstream::app);

	fh << "\n" << setting << "=" << defsetting;

	fh.close();
}
void write_settings(const char* setting, int defsetting)
{
	ofstream fh;
	fh.open(get_cfile().c_str(),ofstream::app);

	fh << "\n" << setting << "=" << defsetting;

	fh.close();
}

string get_string(const char* conf, const char* confdefault)
{
	ifstream fh;
	char buf[25];
	string ret;
	string str;
	bool found=false;
	char cmpbuf[50];

	strcpy(cmpbuf,conf);
	strcat(cmpbuf,"=");

	fh.open(get_cfile().c_str());
	while(fh.getline(buf,sizeof(buf)))
	{
		if (strncmp(buf,cmpbuf,strlen(cmpbuf))==0)
		{
			std::string str(buf);
			ret=str.substr(strlen(conf)+1,str.size()-strlen(conf)+1);
			found=true;
		}
	}

	fh.close();

	if (!found)
	{
		write_settings(conf,confdefault);
		return confdefault;
	}

	return ret;

}

int get_int(const char* conf, int confdefault)
{
	ifstream fh;
	char buf[25];
	int ret;
	string str;
	bool found=false;
	char cmpbuf[50];

	strcpy(cmpbuf,conf);
	strcat(cmpbuf,"=");

	fh.open(get_cfile().c_str());
	while(fh.getline(buf,sizeof(buf)))
	{
		if (strncmp(buf,cmpbuf,strlen(cmpbuf))==0)
		{
			std::string str(buf);
			ret=atoi(str.substr(strlen(conf)+1,str.size()-strlen(conf)+1).c_str());
			found=true;
		}
	}

	fh.close();

	if (!found)
	{
		write_settings(conf,confdefault);
		return confdefault;
	}

	return ret;

}
