/*
 * Game.cpp
 *
 *  Created on: 08.11.2012
 *      Author: Maik Stubbe
 *
 * Copyright (2012) Maik Stubbe
 *
 * This file is part of nDarX.
 *
 * nDarX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version.
 * 
 * nDarx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with nDarx.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Game.h"

void game(const char *pname, int startScore, int allTime)
{
	Player p1(startScore,1,pname, allTime);
	X01 x01(&p1);

	WINDOW *m_window;
	WINDOW *x_window;
	WINDOW *i_window;
	WINDOW *s_window;
	int ch, startx, starty;
	int height = 4;
	int width = 10;
	int mheight=get_mheight();
	int mwidth=get_mwidth();
	int swidth=get_mwidth()-16;
	int sheight=8;
	char str[3];
	int ret;
	int throws;
	bool stop = false;
	float ave;

	startx = get_mstartx()+8;
	starty = get_mstarty()+3;

#ifdef debug
	//printw("hstartx: %d - hstarty: %d",startx, starty);
	//refresh();
#endif

	m_window = create_newwin(mheight,mwidth,get_mstarty(),get_mstartx());
	x_window = create_newwin(height,width,starty,startx);
	i_window = create_newwin(height,width,starty,startx+width+18);
	s_window = create_newwin(sheight,swidth,starty+height+1,startx);


	keypad(i_window,TRUE);
	curs_set(0);
	wattron(i_window,A_BOLD);
	mvwprintw(i_window,1,1," Scored:");
	wattroff(i_window,A_BOLD);
	wattron(x_window,A_BOLD);
	mvwprintw(x_window,1,1,"  Score:");
	wattroff(x_window,A_BOLD);
	mvwprintw(x_window,2,1,"    %d",x01.get_score());
	wattron(s_window,A_BOLD);
	mvwprintw(s_window,1,swidth/2-sizeof("1-Dart Ave")/2,"1-Dart Ave");
	mvwprintw(s_window,3,swidth/2-sizeof("3-Dart Ave")/2,"3-Dart Ave");
	mvwprintw(s_window,5,swidth/2-sizeof("60 - 100 - 140 - 180")/2,"60 - 100 - 140 - 180");
	wattroff(s_window,A_BOLD);

	wattron(m_window,A_BOLD);
	mvwprintw(m_window,1,(get_mwidth()/2)-3,"Player");
	wattroff(m_window,A_BOLD);
	mvwprintw(m_window,2,(get_mwidth()/2)-(sizeof(pname)/2),pname);


	wrefresh(m_window);
	wrefresh(s_window);
	wrefresh(x_window);

	wmove(i_window,2,1);

	wrefresh(i_window);



	while (!stop)
	{

		wgetstr(i_window,str);
		mvwprintw(m_window,mheight-2,mwidth/2-2,"    ");
		wrefresh(m_window);

		if (strcmp(str,"q") == 0)
		{
			stop = true;
		}
		else
		{
			ret = x01.set_score(atoi(str));

			mvwprintw(i_window,2,1,"    ");
			wmove(i_window,2,1);
			wrefresh(i_window);
			mvwprintw(x_window,2,1,"        ");
			mvwprintw(x_window,2,1,"    %d",p1.get_score());
			wrefresh(x_window);


			if (ret == -1)
			{
				beep();
				wattron(m_window,A_BOLD);
				wattron(m_window,A_BLINK);
				mvwprintw(m_window,mheight-2,mwidth/2-2,"Bust");
				wattroff(m_window,A_BOLD);
				wattroff(m_window,A_BLINK);
				wrefresh(m_window);
			}
			else if (ret == 0)
			{
				throws = open_win();
				x01.set_throws(throws);
				save_stats(pname, startScore,x01.get_gthrows(),x01.get_gt60(),x01.get_gt100(),x01.get_gt140(),x01.get_gt180());
				ave = x01.get_ave(startScore);

				mvwprintw(s_window,2,swidth/2-sizeof(ave)/2,"%f",ave);
				mvwprintw(s_window,4,swidth/2-sizeof(ave)/2,"%f",ave*3);
				mvwprintw(s_window,6,swidth/2-6,"%d - %d - %d - %d",x01.get_t60(),x01.get_t100(),x01.get_t140(),x01.get_t180());
				wrefresh(s_window);
				mvwprintw(i_window,2,1,"    ");
				wmove(i_window,2,1);
				wrefresh(i_window);

				x01.restart(startScore);
				mvwprintw(x_window,2,1,"        ");
				mvwprintw(x_window,2,1,"    %d",p1.get_score());
				wrefresh(x_window);
			}

			if (ret != 0)
			{
				ave = x01.get_ave(startScore);

				mvwprintw(s_window,2,swidth/2-sizeof(ave)/2,"%f",ave);
				mvwprintw(s_window,4,swidth/2-sizeof(ave)/2,"%f",ave*3);
				mvwprintw(s_window,6,swidth/2-6,"%d - %d - %d - %d",x01.get_t60(),x01.get_t100(),x01.get_t140(),x01.get_t180());
				wrefresh(s_window);
			}

		}

	}

	destroy_win(x_window);
	destroy_win(i_window);
	destroy_win(s_window);
	destroy_win(m_window);

}

int open_win()
{
	int ret;
	char str[3];
	bool stop = false;

	WINDOW *w_window;

	w_window = create_newwin(4,20,get_mstarty()+(get_mwidth()/2)-10,get_mstartx()+(get_mwidth()/2)-10);

	mvwprintw(w_window,1,1,"No. of Throws:");

	while (!stop)
	{
		mvwgetstr(w_window,2,1,str);


		ret = atoi(str);

		switch (ret)
		{
		case 1:
			ret = 1;
			stop = true;
			break;
		case 2:
			ret = 2;
			stop = true;
			break;
		case 3:
			ret = 3;
			stop = true;
			break;
		default:
			break;
		}
	}

	destroy_win(w_window);
	return ret;
}
